//
//  YHWaitAppointMembersCell.swift
//  galaxy
//
//  Created by edy on 2024/8/22.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHWaitAppointMembersCell: UITableViewCell {

    static let cellReuseIdentifier = "YHWaitAppointMembersCell"
    var clickBlock: (()->())?
    
    var members:[YHHKMemberModel] = [] {
        didSet {
            var text = ""
            for (index, user) in members.enumerated() {
                text += "\(user.name)"
                if index != members.count-1 {
                    text += "、"
                }
            }
            detailLabel.text = text
        }
    }

    lazy var whiteContentView: UIView = {
        let view = UIView()
        view.backgroundColor = .white
        view.layer.cornerRadius = kCornerRadius6
        return view
    }()
    
    lazy var titleLabel: UILabel = {
        let label = UILabel()
        label.numberOfLines = 0
        label.textColor = .mainTextColor
        label.font = UIFont.PFSC_M(ofSize: 14)
        label.text = "待预约赴港成员"
        return label
    }()
    
    lazy var lineView: UIView = {
        let view = UIView()
        view.backgroundColor = .separatorColor
        return view
    }()
    
    lazy var detailLabel: UILabel = {
        let label = UILabel()
        label.numberOfLines = 0
        label.textColor = .mainTextColor(alpha: 0.7)
        label.font = UIFont.PFSC_R(ofSize: 14)
        return label
    }()
    
    lazy var bottomBtn: UIButton = {
        let btn = UIButton()
        btn.backgroundColor = .brandMainColor
        btn.setTitle("去预约", for: .normal)
        btn.setTitleColor(.white, for: .normal)
        btn.titleLabel?.font = .PFSC_M(ofSize: 14)
        btn.layer.cornerRadius = 4.0
        btn.addTarget(self, action: #selector(didBottomBtnClicked), for: .touchUpInside)
        return btn
    }()
    
    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    @objc func didBottomBtnClicked() {
        clickBlock?()
    }
    
    func setupUI() {
        
        self.selectionStyle = .none
        self.backgroundColor = .clear
        self.contentView.backgroundColor = .clear
        contentView.addSubview(whiteContentView)
        whiteContentView.addSubview(titleLabel)
        whiteContentView.addSubview(detailLabel)
        whiteContentView.addSubview(bottomBtn)
        whiteContentView.addSubview(lineView)
        
        whiteContentView.snp.makeConstraints { make in
            make.top.equalTo(16)
            make.left.equalTo(16)
            make.right.equalTo(-16)
            make.bottom.equalTo(0)
        }
        
        titleLabel.snp.makeConstraints { make in
            make.top.equalTo(16)
            make.left.equalTo(18)
            make.right.equalTo(-18)
        }
        
        lineView.snp.makeConstraints { make in
            make.top.equalTo(titleLabel.snp.bottom).offset(12)
            make.left.equalTo(0)
            make.right.equalTo(0)
            make.height.equalTo(0.5)
        }
        
        detailLabel.snp.makeConstraints { make in
            make.top.equalTo(lineView.snp.bottom).offset(16)
            make.left.equalTo(18)
            make.right.equalTo(-18)
        }
        
        bottomBtn.snp.makeConstraints { make in
            make.top.equalTo(detailLabel.snp.bottom).offset(16)
            make.left.equalTo(18)
            make.right.equalTo(-18)
            make.height.equalTo(45)
            make.bottom.equalTo(-16)
        }
    }
}
